/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.block;

import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import novamachina.exnihilosequentia.common.block.BaseBlock;
import novamachina.exnihilosequentia.common.blockentity.crucible.BaseCrucibleEntity;
import novamachina.exnihilosequentia.common.builder.BlockBuilder;
import novamachina.exnihilosequentia.common.compat.top.ITOPInfoProvider;
import org.jetbrains.annotations.NotNull;

public class CrucibleBaseBlock
extends BaseBlock
implements ITOPInfoProvider {
    public CrucibleBaseBlock(@Nonnull BlockBuilder builder) {
        super(builder);
    }

    @Override
    public void addProbeInfo(@Nonnull ProbeMode probeMode, @Nonnull IProbeInfo probeInfo, @Nonnull Player playerEntity, @Nonnull Level world, @Nonnull BlockState blockState, @Nonnull IProbeHitData data) {
        if (probeMode == ProbeMode.EXTENDED) {
            this.gatherExtendedData(probeInfo, world, data);
        }
    }

    private void gatherExtendedData(@NotNull IProbeInfo probeInfo, @NotNull Level world, @NotNull IProbeHitData data) {
        BaseCrucibleEntity crucibleTile = (BaseCrucibleEntity)world.m_7702_(data.getPos());
        if (crucibleTile == null) {
            return;
        }
        this.addSolidInformation(probeInfo, crucibleTile);
        this.addFluidInformation(probeInfo, crucibleTile);
        this.addHeatInformation(probeInfo, crucibleTile);
    }

    private void addHeatInformation(@NotNull IProbeInfo probeInfo, @NotNull BaseCrucibleEntity crucibleTile) {
        if (crucibleTile.getHeat() == 0) {
            probeInfo.text((Component)new TranslatableComponent("waila.crucible.no_heat"));
        } else {
            probeInfo.text((Component)new TranslatableComponent("waila.crucible.heat", new Object[]{crucibleTile.getHeat()}));
        }
    }

    private void addFluidInformation(@NotNull IProbeInfo probeInfo, @NotNull BaseCrucibleEntity crucibleTile) {
        Fluid fluid;
        if (crucibleTile.getFluidAmount() > 0 && (fluid = crucibleTile.getFluid()) != null) {
            probeInfo.text((Component)new TranslatableComponent("waila.crucible.fluid", new Object[]{new TranslatableComponent(fluid.m_76145_().m_76188_().m_60734_().m_7705_()), crucibleTile.getFluidAmount()}));
        }
    }

    private void addSolidInformation(@NotNull IProbeInfo probeInfo, @NotNull BaseCrucibleEntity crucibleTile) {
        if (crucibleTile.getSolidAmount() > 0) {
            ItemStack itemStack = crucibleTile.getCurrentItem();
            probeInfo.text((Component)new TranslatableComponent("waila.crucible.solid", new Object[]{new TranslatableComponent(itemStack.m_41720_().m_5524_()), crucibleTile.getSolidAmount()}));
        }
    }

    @Nonnull
    @Deprecated(forRemoval=false)
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        if (worldIn.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BaseCrucibleEntity tile = (BaseCrucibleEntity)worldIn.m_7702_(pos);
        if (tile != null) {
            IFluidHandler fluidHandler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit.m_82434_()).orElseThrow(() -> new RuntimeException("Missing Fluid Handler"));
            return tile.onBlockActivated(player, handIn, fluidHandler);
        }
        return InteractionResult.SUCCESS;
    }
}

